/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueStats;
import filenet.vw.api.VWTimeUnitType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminStatisticsTableModel;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWAdminStatsInQueueTableModel
extends VWAdminStatisticsTableModel {
    protected String[] m_queueNames = null;

    public VWAdminStatsInQueueTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) throws Exception {
        super(resultsPane, event);
        if (this.m_vwSession == null) {
            return;
        }
        this.m_queueNames = event.getListOfSelectedItems();
        if (this.m_queueNames == null || this.m_queueNames.length == 0) {
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), VWResource.s_statisticsNoQueueSelection, VWResource.s_statistics, 0);
            return;
        }
        this.initTable();
    }

    protected void retrieveStats() throws Exception {
        VWQueue vwQueue = null;
        VWQueueStats vwQueueStats = null;
        this.m_objectCache.removeAllElements();
        for (int i = 0; i < this.m_queueNames.length; ++i) {
            vwQueue = this.m_vwSession.getQueue(this.m_queueNames[i]);
            if (vwQueue == null || (vwQueueStats = vwQueue.fetchStatistics(this.m_startTime, this.m_endTime, this.m_timeUnits)) == null) continue;
            this.m_objectCache.addElement(vwQueueStats);
        }
    }

    protected void buildAvailableColumnsList() {
        String[] names = null;
        try {
            this.m_availableColumns.removeAllElements();
            names = this.getDefaultColumns();
            for (int i = 0; i < names.length; ++i) {
                this.m_availableColumns.addElement(names[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getObjectAt(int rowIndex) {
        VWQueueStats obj = null;
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        obj = (VWQueueStats)this.m_objectCache.elementAt(rowIndex);
        return obj;
    }

    protected void retrieveRowData() {
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        try {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWQueueStats statsObj = (VWQueueStats)this.m_objectCache.elementAt(i);
                rowData = new Vector<Object>();
                for (int col = 0; col < this.m_headers.size(); ++col) {
                    fieldName = (String)this.m_headers.elementAt(col);
                    fieldValue = this.getFieldValue(statsObj, fieldName);
                    if (fieldValue == null) {
                        fieldValue = "";
                    } else if (VWStringUtils.compare(fieldName, VWResource.s_requestedTimeUnit) == 0) {
                        String typeName = VWTimeUnitType.getLocalizedString((Integer)fieldValue);
                        fieldValue = fieldValue + " (" + typeName + ")";
                    }
                    rowData.addElement(fieldValue);
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void retrieveRowData(int rowIndex) {
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        try {
            VWQueueStats statsObj = (VWQueueStats)this.m_objectCache.elementAt(rowIndex);
            rowData = new Vector<Object>();
            for (int col = 0; col < this.m_headers.size(); ++col) {
                fieldName = (String)this.m_headers.elementAt(col);
                fieldValue = this.getFieldValue(statsObj, fieldName);
                if (fieldValue == null) {
                    fieldValue = "";
                } else if (VWStringUtils.compare(fieldName, VWResource.s_requestedTimeUnit) == 0) {
                    String typeName = VWTimeUnitType.getLocalizedString((Integer)fieldValue);
                    fieldValue = fieldValue + " (" + typeName + ")";
                }
                rowData.addElement(fieldValue);
            }
            this.m_rowCache.setElementAt(rowData, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String[] getDefaultColumns() {
        Vector<String> columnNames = null;
        Object[] names = null;
        try {
            columnNames = new Vector<String>();
            columnNames.addElement(VWResource.s_averageProcessedWO);
            columnNames.addElement(VWResource.s_averageQueueDelay);
            columnNames.addElement(VWResource.s_averageQueueDepth);
            columnNames.addElement(VWResource.s_averageThroughput);
            columnNames.addElement(VWResource.s_averageWOLocked);
            columnNames.addElement(VWResource.s_averageWOProcessingTime);
            columnNames.addElement(VWResource.s_currentQueueDepth);
            columnNames.addElement(VWResource.s_currentWOLocked);
            columnNames.addElement(VWResource.s_dequeuedRate);
            columnNames.addElement(VWResource.s_endTime);
            columnNames.addElement(VWResource.s_evaluationTime);
            columnNames.addElement(VWResource.s_initialNumberOfQueued);
            columnNames.addElement(VWResource.s_numberOfRemainingQueued);
            columnNames.addElement(VWResource.s_numberOfSamples);
            columnNames.addElement(VWResource.s_numberOfUnitsInPeriod);
            columnNames.addElement(VWResource.s_numberOfWOLocked);
            columnNames.addElement(VWResource.s_numberOfWOProcessed);
            columnNames.addElement(VWResource.s_queuedRate);
            columnNames.addElement(VWResource.s_queueGrowthRate);
            columnNames.addElement(VWResource.s_requestedEndTime);
            columnNames.addElement(VWResource.s_requestedStartTime);
            columnNames.addElement(VWResource.s_requestedTimeUnit);
            columnNames.addElement(VWResource.s_startTime);
            columnNames.addElement(VWResource.s_summationDurationWOInQueue);
            columnNames.addElement(VWResource.s_summationQueueDepth);
            columnNames.addElement(VWResource.s_summationWOLocked);
            columnNames.addElement(VWResource.s_summationWOProcessed);
            columnNames.addElement(VWResource.s_totalAbortedTime);
            columnNames.addElement(VWResource.s_totalServiceTime);
            columnNames.addElement(VWResource.s_totalWOAborted);
            columnNames.addElement(VWResource.s_totalWODequeued);
            columnNames.addElement(VWResource.s_totalWOQueued);
            names = new String[columnNames.size()];
            columnNames.copyInto(names);
            return names;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected Object getFieldValue(VWQueueStats obj, String colName) {
        Object fieldValue;
        block36: {
            fieldValue = null;
            try {
                if (VWStringUtils.compare(colName, VWResource.s_averageProcessedWO) == 0) {
                    fieldValue = obj.getAverageProcessedWO();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageQueueDelay) == 0) {
                    fieldValue = obj.getAverageQueueDelay();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageQueueDepth) == 0) {
                    fieldValue = obj.getAverageQueueDepth();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageThroughput) == 0) {
                    fieldValue = obj.getAverageThroughput();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageWOLocked) == 0) {
                    fieldValue = obj.getAverageWOLocked();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageWOProcessingTime) == 0) {
                    fieldValue = obj.getAverageWOProcessingTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_currentQueueDepth) == 0) {
                    fieldValue = obj.getCurrentQueueDepth();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_currentWOLocked) == 0) {
                    fieldValue = obj.getCurrentWOLocked();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_dequeuedRate) == 0) {
                    fieldValue = obj.getDequeuedRate();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_endTime) == 0) {
                    fieldValue = obj.getEndTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_evaluationTime) == 0) {
                    fieldValue = obj.getEvaluationTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_initialNumberOfQueued) == 0) {
                    fieldValue = obj.getInitialNumberOfQueued();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfRemainingQueued) == 0) {
                    fieldValue = obj.getNumberOfRemainingQueued();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfSamples) == 0) {
                    fieldValue = obj.getNumberOfSamples();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfUnitsInPeriod) == 0) {
                    fieldValue = obj.getNumberOfUnitsInPeriod();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfWOLocked) == 0) {
                    fieldValue = obj.getNumberOfWOLocked();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfWOProcessed) == 0) {
                    fieldValue = obj.getNumberOfWOProcessed();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_queuedRate) == 0) {
                    fieldValue = obj.getQueuedRate();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_queueGrowthRate) == 0) {
                    fieldValue = obj.getQueueGrowthRate();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_queueName) == 0) {
                    fieldValue = obj.getQueueName();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_requestedEndTime) == 0) {
                    fieldValue = obj.getRequestedEndTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_requestedStartTime) == 0) {
                    fieldValue = obj.getRequestedStartTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_requestedTimeUnit) == 0) {
                    fieldValue = new Integer(obj.getRequestedTimeUnit());
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_startTime) == 0) {
                    fieldValue = obj.getStartTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationDurationWOInQueue) == 0) {
                    fieldValue = obj.getSummationDurationWOInQueue();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationQueueDepth) == 0) {
                    fieldValue = obj.getSummationQueueDepth();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationWOLocked) == 0) {
                    fieldValue = obj.getSummationWOLocked();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationWOProcessed) == 0) {
                    fieldValue = obj.getSummationWOProcessed();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalAbortedTime) == 0) {
                    fieldValue = obj.getTotalAbortedTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalServiceTime) == 0) {
                    fieldValue = obj.getTotalServiceTime();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalWOAborted) == 0) {
                    fieldValue = obj.getTotalWOAborted();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalWODequeued) == 0) {
                    fieldValue = obj.getTotalWODequeued();
                    break block36;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalWOQueued) == 0) {
                    fieldValue = obj.getTotalWOQueued();
                    break block36;
                }
                return null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (fieldValue instanceof Date && !this.validateDate(fieldValue)) {
            fieldValue = null;
        }
        return fieldValue;
    }
}

